/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.common.LootStashDetectorHandler;
import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class S2C_SetTrackedStashPacket
extends AbstractNetworkPacket<S2C_SetTrackedStashPacket> {
    private final Type type;
    private final BlockPos pos;

    public S2C_SetTrackedStashPacket() {
        this.pos = null;
        this.type = Type.UNSET;
    }

    public S2C_SetTrackedStashPacket(BlockPos pos) {
        this.pos = pos;
        this.type = Type.SET;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.type);
        if (this.type == Type.SET) {
            buffer.func_179255_a(this.pos);
        }
    }

    @Override
    public S2C_SetTrackedStashPacket decode(PacketBuffer buffer) {
        Type type = (Type)buffer.func_179257_a(Type.class);
        if (type == Type.SET) {
            return new S2C_SetTrackedStashPacket(buffer.func_179259_c());
        }
        return new S2C_SetTrackedStashPacket();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        LootStashDetectorHandler.DetectionData data = LootStashDetectorHandler.getData(player.func_110124_au());
        if (this.type == Type.SET) {
            data.setTrackedLocation(this.pos);
        } else {
            data.setTrackedLocation(null);
        }
    }

    public static enum Type {
        SET,
        UNSET;

    }
}

